/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.command;

import oracle.ops.mgmt.command.CommandResult;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.command.VerificationCommand;
import oracle.ops.verification.framework.engine.Result;

public class DeleteFileCommand
extends VerificationCommand {
    protected String file;
    String m_location;

    public DeleteFileCommand(String node, String file) {
        super(node);
        this.file = file;
    }

    @Override
    public boolean execute() {
        Result result = this.getResult();
        String retval = null;
        Trace.out((String)("DeleteFileCommand:: Inside execute() [Thread:" + Thread.currentThread().getName() + "]"));
        result.addTraceInfo("DeleteFileCommand::Inside execute() " + Thread.currentThread().getName());
        try {
            retval = this.nativeSystem.removeFile(this.m_node, this.file);
        }
        catch (Exception e) {
            result.addTraceInfo("DeleteFileCommand::execute() Exception calling native system");
            Trace.out((String)"DeleteFileCommand::execute() Exception calling native system");
            result.setStatus(2);
            return false;
        }
        CommandResult commandResult = new CommandResult(retval);
        if (commandResult == null) {
            Trace.out((String)"DeleteFileCommand::execute() Command failed!");
            result.addTraceInfo("DeleteFileCommand::execute() Command failed!");
            result.addErrorInfo("DeleteFileCommand::execute() Command failed!");
            result.setStatus(2);
            return false;
        }
        if (commandResult.getStatus() && commandResult.getResultString() != null) {
            result.setStatus(1);
            return true;
        }
        Trace.out((String)("ERROR:DeleteFileCommand:: " + commandResult.getResultString()));
        result.addErrorInfo("ERROR:DeleteFileCommand:: " + commandResult.getResultString());
        result.addTraceInfo("ERROR:DeleteFileCommand:: " + commandResult.getResultString());
        result.setStatus(2);
        return false;
    }
}

